// SPDX-FileCopyrightText: 2025 g10 code GmbH
// SPDX-Contributor: Carl Schwan <carl.schwan@gnupg.com>
// SPDX-License-Identifier: GPL-2.0-or-later

import messages from '../translation.js'

export function i18n(text) {
  const lang = Office.context.displayLanguage
  let result = '';
  if (lang in messages && text in messages[lang]) {
    result = messages[lang][text];
  } else {
    result = text;
  }

  for (let i = 1; i < arguments.length; i++) {
    result = result.replace("%" + i, arguments[i]);
  }
  return result;
}

export function i18nc(context, text) {
  const lang = Office.context.displayLanguage

  let result = '';
  if (lang in messages && text in messages[lang]) {
    result = messages[lang][text];
  } else {
    result = text;
  }

  for (let i = 2; i < arguments.length; i++) {
    result = result.replace("%" + (i - 1), arguments[i]);
  }
  return result;
}
