# let current powershell execute this script:
#   Set-ExecutionPolicy -ExecutionPolicy RemoteSigned -Scope Process

param (
  [Switch]$list
  , [Switch]$delete
)

$allgnupgcerts = Get-ChildItem -Path Cert:\CurrentUser\Root\ -recurse | Where-Object {$_.Subject -match "GnuPG Outlook Add-in Local Root CA"}

if ($allgnupgcerts) {
  if ($list -eq $true) {
    Out-GridView -InputObject $allgnupgcerts
  }
  elseif ($delete -eq $true) {
    forEach ($i in $allgnupgcerts) {
      $thisTP = ($i).Thumbprint
      Write-Host "Removing CA Certificate $thisTP from registry of current user"
      Remove-Item "HKCU:\Software\Microsoft\SystemCertificates\Root\Certificates\$thisTP" -Force
    }
  }
  else {
    Write-Host "Use either -list or -delete flags to tell what you want to do!"
  }
}
else {
  Write-Host "No GnuPG Outlook Add-in Local Root CA certificate found for current user."
}
