# Communication Overview

Every communication is encrypted via a self-signed TLS certificate.

## Components involved

* **Exchange**  
  This is the Microsoft server, either an exchange instance or the
  MS-365 infrastructure.

* **Outlook**  
  The actual mail clients.  Outlook may be used intwo forms:

  1. Outlook/Exe :: The installed outlook application

  2. Outlook/Web :: The outlook application running in a browser

* **GpgOL-Server**  
  This is the broker between Outlook and GpgOL-Client. It is
  responsible to manage several client instances and may also be
  installed as a central service within a corporate network.  The
  server also delivers the Javascript used by Outlook. It provides
  the following services on the same port 5656:

  1. *HTTP Server*  
    The HTTP server only serve static content, this includes HTML, CSS, JavaScript
    and some assets.

  2. *Web Socket Server*  
    On the same port as the HTTP server, there is also a websocket server which both
    native and web clients connect to via a JSON based protocols:

    ```json
    {
      "command": "<command-name>",
      "arguements": {
          "<key>": "<value>",
      }
    }
    ```

* **GpgOL-Client**  
  The client is the actual crypt MUA part which extends Outlook.  It
  communicates via GpgOL-Server and is responsbile for the crypto
  operations and to show and compose messages.



## Commands

Here is an overview of the most important commands, they are all defined in the
`common/protocol.h` class used by both gpgol-client and gpgol-server.

### `register` and `connection`

This creates a mapping from email address to sockets in the server which latter
on is used to forward the messages.

```json
{
  "command": "register",
  "arguements": {
      "type": "webclient|native",
      "emails": ["email1@example.org", "email2@example.org"]
      "id": "<unique-id>", // only for native
      "name": "<name of the computer>" // only for native
  }
}
```

The list of emails for a web client is the result of
`Office.context.mailbox.userProfile.emailAddress` which returns the email
address of the current account.

The list of emails for a native client is the list of GpgME::UserId with a
private key in the keyring.

If when registering a native client, the web clients with a matching email
address will be notified with the following message. A similar message will
be send to the web client when they connect.

```JSON
{
  "command": "connection",
  "arguments": {
    "type": "client",
    "id": "<unique-id>",
    "name": "<name of the computer>",
  }
}
```

The user will be asked to authorize the new device and then the id will be
added to the list of `verifiedNativeClients`. This is saved accross section in
the web storage API, so that the device only needs to be verified the first time.

### `info`

This ask the native client to fetch the MIME content of the email and cache it locally.

`ewsAccessToken` is the secret OAuth token used to authentificate the EWS requests made
my the native client.

`itemId` is the EWS item id which is used a unique identifier in EWS and in GpgOL/Web

```json
{
  "command": "info",
  "arguements": {
    "itemId": "the itemid of the email",
    "email": "email1@example.org",
    "ewsAccessToken": "TOKEN",
    "verifiedNativeClients": [ "<unique-id>" ]
  }
}
```

### `info-fetched`

Once the information is fetched, the native client will send a "status-update" (see below), and then the following back to gpgol-sever
which is then forwarded to the web client.

```json
{
  "command": "info-fetched",
  "arguements": {
    "itemId": "the EWS id of the email",
    "folderId": "the EWS id of the folder",
    "encrypted": "whether the email is encrypted",
    "signed": "whether the email is signed",
    "version": "The version of the native client",
    "verifiedNativeClients": [ "<unique-id>" ]
  }
}
```

### `status-update`

Whenever information changes that is not directly related to a specific email, the native client sends this command:

```json
{
  "command": "info-fetched",
  "arguements": {
    "drafts": [ "draft 1", "draft 2" ],
    "viewerOpen": "whether the email viewer is open",
    "features": [ "reencrypt" ]
  }
}
```

### Other commands

Most commands follow the same format and are simply forwarded to the native client:

```json
{
  "command": "view|reencrypt|reply|forward|composer",
  "arguements": {
    "itemId": "the itemid of the email",
    "folderId": "the EWS id of the folder",
    "email": "email1@example.org",
    "displayName": "Foo Bar",
    "ewsAccessToken": "TOKEN",
    "verifiedNativeClients": [ "<unique-id>" ]
  }
}
```

### Special EWS commands

In the normal case, we get an EWS access token via OAuth and then the EWS
requests are directly done in the native client. To support legacy servers,
we also support doing EWS in the web client. In which case the native client,
send the following command:

```json
{
  "command": "ews",
  "arguements": {
    "body": "EWS request body, this is nested XML",
    "email": "email1@example.org",
    "requestId": "unique identifier for the request",
  }
}
```

the web client will then run this EWS request in JavaScript and return the following,
which is then send back to the native client.

```json
{
  "command": "ews-response",
  "arguements": {
    "body": "EWS response body, this is nested XML",
    "email": "email1@example.org",
    "requestId": "unique identifier for the request, same as before",
  }
}
```
