#pragma once

#include <QString>
#include <algorithm>
#include <cctype>

namespace Formatter
{

inline QString formatX509Fingerprint(QByteArrayView fingerprint)
{
    if (fingerprint.isEmpty()) {
        return {};
    }
    if (fingerprint.size() % 2 != 0) {
        return {};
    }
    if (std::find_if_not(fingerprint.begin(),
                         fingerprint.end(),
                         [](unsigned char c) {
                             return std::isxdigit(c);
                         })
        != fingerprint.end()) {
        return {};
    }
    return QString::fromLatin1(QByteArray::fromHex(fingerprint.toByteArray()).toHex(':')).toUpper();
}
}
