// SPDX-FileCopyrightText: 2025 g10 code GmbH
// SPDX-FileContributor: Carl Schwan <carl.schwan@gnupg.com>
// SPDX-License-Identifier: GPL-2.0-or-later

#pragma once

#include "ews/ewsclient.h"
#include "ews/ewsid.h"
#include "ews/ewsitem.h"

#include <KCompositeJob>

class EwsFindItemRequest;

class EwsGetFolderContentRequest : public KCompositeJob
{
    Q_OBJECT
public:
    EwsGetFolderContentRequest(const EwsId &folderId, const EwsClient &client);
    ~EwsGetFolderContentRequest();

    void start() override;

    int totalItems() const;
    int offset() const;

private:
    void emailListFetched(KJob *job);
    void emailContentFetched(KJob *job);

Q_SIGNALS:
    void fetchedItems(const QList<EwsItem> &items);

private:
    EwsId m_folderId;
    EwsClient m_ewsClient;
    int m_totalItems = 0;
    int m_offset = 0;
    EwsFindItemRequest *m_currentFindItemRequest = nullptr;
};
