// SPDX-FileCopyrightText: 2024 g10 code GmbH
// SPDX-Contributor: Carl Schwan <carl.schwan@gnupg.com>
// SPDX-License-Identifier: GPL-2.0-or-later

#pragma once

#include <KJob>

#include <gpgme++/importresult.h>
#include <gpgme++/key.h>
#include <gpgme++/keygenerationresult.h>
#include <gpgme++/keylistresult.h>
#include <qgpgme/job.h>
class QTemporaryDir;

static const QLatin1StringView ROOT_NAME = QLatin1StringView("rootCA.pem");

class Controller : public KJob
{
    Q_OBJECT

public:
    explicit Controller(QObject *parent = nullptr);

    static bool certificateAlreadyGenerated();

    QString caUniqueName() const;
    QByteArray caCert() const;

    void start() override;

    ~Controller();

Q_SIGNALS:
    void debutOutput(const QString &output);

private:
    void slotRootCaCreatedSlot(const GpgME::KeyGenerationResult &result, const QByteArray &request, const QString &auditLog);

    void slotRootCaImportedSlot(const GpgME::ImportResult &result, const QString &auditLogAsHtml, const GpgME::Error &auditLogError);

    void slotKeyGripOptained(const GpgME::KeyListResult &result,
                             const std::vector<GpgME::Key> &keys,
                             const QString &auditLogAsHtml,
                             const GpgME::Error &auditLogError);

    void slotCertCreatedSlot(const GpgME::KeyGenerationResult &result, const QByteArray &request, const QString &auditLog);

    void slotCertImportedSlot(const GpgME::ImportResult &result, const QString &auditLogAsHtml, const GpgME::Error &auditLogError);

    void checkFinished();
    void install();

    void setHomeDirForJob(QGpgME::Job *job);

private:
    GpgME::Key m_ca;
    QByteArray m_publicCA;
    QByteArray m_secretCA;

    std::unique_ptr<QTemporaryDir> m_tmpdir;
    GpgME::Key m_tls;
    QByteArray m_publicTLS;
    QByteArray m_secretTLS;
};
