// SPDX-FileCopyrightText: 2024 g10 Code GmbH
// SPDX-FileContributor: Carl Schwan <carl.schwan@gnupg.com>
// SPDX-License-Identifier: GPL-2.0-or-later

#include "welcomewidget.h"

#include <QVBoxLayout>

#include <KLocalizedString>

#include "gpgpass_version.h"
#include "widgets/kplaceholderwidget.h"

WelcomeWidget::WelcomeWidget(QWidget *parent)
    : QWidget(parent)
{
    auto layout = new QVBoxLayout(this);

    auto welcomeWidget = new KPlaceholderWidget;
    welcomeWidget->setTitle(i18nc("@title", "Welcome to GnuPG Password manager"));
    welcomeWidget->setText(i18nc("@info", "Version %1", QString::fromLocal8Bit(GPGPASS_VERSION_STRING)));
    welcomeWidget->setPixmap(QPixmap(QStringLiteral(":/artwork/64-gpgpass.png")));

    layout->addStretch();
    layout->addWidget(welcomeWidget);
    layout->addStretch();
}

WelcomeWidget::~WelcomeWidget() = default;
