// SPDX-FileCopyrightText: 2025 g10 code GmbH
// SPDX-FileContributor: Carl Schwan <carl.schwan@gnupg.com>
// SPDX-License-Identifier: GPL-2.0-or-later

#pragma once

#include "ews/ewsfolder.h"

#include <Libkleo/DefaultKeyFilter>
#include <QDialog>
#include <gpgme++/key.h>

namespace Kleo
{
class KeySelectionCombo;
class CertificateLineEdit;
class AbstractKeyListModel;
}

class KMessageWidget;
class QVBoxLayout;
class QLabel;
class QButtonGroup;

enum class UnencryptedMode {
    Skip,
    Copy,
};

class ChooseKeyDialog : public QDialog
{
    Q_OBJECT

public:
    explicit ChooseKeyDialog(const EwsFolder &ewsFolder, QWidget *parent = nullptr);
    std::vector<GpgME::Key> currentKeys() const;
    UnencryptedMode unencryptedMode() const;

private:
    void recipientsChanged();

    QLabel *m_recipientsLabel;
    Kleo::CertificateLineEdit *addRecipientWidget();
    Kleo::CertificateLineEdit *insertRecipientWidget(Kleo::CertificateLineEdit *after);
    EwsFolder m_ewsFolder;
    std::shared_ptr<Kleo::DefaultKeyFilter> m_keyFilter;
    QVBoxLayout *m_recpLayout = nullptr;
    QList<Kleo::CertificateLineEdit *> m_recpWidgets;
    Kleo::AbstractKeyListModel *m_model = nullptr;
    QButtonGroup *m_unencrypted;
};
