import { fileURLToPath, URL } from 'node:url'

import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'
import fs from 'fs'

function updateNSIS() {
  console.log('updatig assets/inst-gpgoljs-assets.nsi:')
  const indexFiles = fs.readdirSync('./dist/assets/', {withFileTypes: true}).filter(item => !item.isDirectory()).map(item => item.name)
  var stream = fs.createWriteStream('assets/inst-gpgoljs-assets.nsi');
  for (let i = 0; i < indexFiles.length; i++) {
    console.log('  File \${prefix}/share/gpgol-web/assets/' + indexFiles[i])
    stream.write('  File \${prefix}/share/gpgol-web/assets/' + indexFiles[i] + '\n');
  }
  stream.end();
};

// https://vite.dev/config/
export default defineConfig({
  plugins: [
    vue(),
    {
      name: 'update-nsis',
      closeBundle: async () => {
        await updateNSIS();
      }
    },
  ],
  resolve: {
    alias: {
      '@': fileURLToPath(new URL('./src', import.meta.url))
    },
  },
})
