// SPDX-FileCopyrightText: 2023 g10 code GmbH
// SPDX-Contributor: Carl Schwan <carl.schwan@gnupg.com>
// SPDX-License-Identifier: GPL-2.0-or-later

#include <QCoreApplication>
#include <QDir>
#include <QFile>
#include <QJsonDocument>
#include <QJsonObject>
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QSslCertificate>
#include <QSslKey>

#include <KLocalizedString>

#include "../common/log.h"
#include "http_debug.h"
#include "webserver.h"

#ifdef Q_OS_WINDOWS
#include <windows.h>
#endif

using namespace Qt::Literals::StringLiterals;

static void setupLogging(std::shared_ptr<Kleo::Log> log)
{
    const QByteArray dirNative = qgetenv("GPGOL_SERVER_LOGDIR");
    if (dirNative.isEmpty()) {
        return;
    }
    log->setOutputDirectory(QFile::decodeName(dirNative));
    qInstallMessageHandler(Kleo::Log::messageHandler);
}

int main(int argc, char *argv[])
{
    QCoreApplication app(argc, argv);

    KLocalizedString::setApplicationDomain(QByteArrayLiteral("gpgol-js-native"));

    auto log = Kleo::Log::mutableInstance();
    setupLogging(log);

#ifdef Q_OS_WINDOWS
    if (AttachConsole(ATTACH_PARENT_PROCESS)) {
        freopen("CONOUT$", "w", stdout);
        freopen("CONOUT$", "w", stderr);
    }
#endif

    WebServer webServer;

    if (!webServer.run()) {
        qCWarning(HTTP_LOG) << "Server failed to listen on a port.";
        return 1;
    }

    return app.exec();
}
