# GpgOL/Web

This project provides a GnuPG integration for users of Outlook Web.


## Files and directories you see here

- doc/communication.md      :: Technical description of client/server communication
- doc/mime.md      :: MIME structure of e-mails
- doc/security.md      :: Security assessment
- common/  :: Helper code
- server/  :: The broker/proxy part to connect Outlook with our client
- client/  :: The client representing our mail GUI


## Overview

GpgOL/Web is a re-implementation of our Outlook plug-in GpgOL, bringing GnuPG
support to the web-based version of Outlook. The older application-based
Outlook had a very different plug-in interface, hence this new implementation
also uses a completely new architecture and user experience.

The new Outlook is a web service with support for user defined add-ins. The
GpgOL/Web add-in is split into two components:

- a **proxy component** that connects to the Outlook server to provide the
user interface (*»web client«*) and fetch or send (encrypted) emails, and
- a **client component** that recieves emails from the proxy component and
transfers emails back to it and takes care of the actual decryption,
encryption and signature tasks.

The GpgOL/Web client component always runs locally on your computer, whereas
its proxy component can either also run locally, or on a dedicated server
(e.g. in larger organizations). In case you are the only user or want to
test the add-in, you will likely run the proxy on the same machine.

The proxy component must also provide a **TLS certificate** to secure the
information exchange between client and server. This can either be a
self-signed certificate generated during installation, or an already
existing certificate (e.g., signed by your organization's CA). In case your
organization runs the proxy component on a dedicated server, you usually
don't have to worry about this, because the certificate is already installed
on the server as well. Only if you run the proxy component locally yourself,
you will have to also deal with providing a sufficient TLS certificate.

Last but not least, Outlook must be configured to actually use the add-in.
To achieve this, a **manifest file** (`manifest.xml`) must be added to your
mail account once. It defines the locations of both client and proxy
component and enables the GpgOL/Web user interface for Outlook. If your account
belongs to a managed domain, your domain administrator can install the add-in
globally for all members of the domain, so you won't have to take care of that
either.

**In summary:** GpgOL/Web needs a running proxy component providing a TLS
certificate, a running client component, and a proper manifest file
registered with Outlook to tell it where to find those components.


### Different installation modi

There's basically two alternatives to install and run GpgOL/Web:

1. install it as a component of Gpg4Win, or
2. build it yourself and run the local installation.

Depending on your method of choice, the steps of running the extensions'
components are a bit different.

In case you used the Gpg4Win installer, you can start the client from the
application menu. A self-signed TLS certificate is autogenerated at first
start. You can then continue with uploading the `manifest.xml` to your
Outlook account and use the extension.

If, on the other hand, you have built your own extension, some further steps
are needed in order to run both components locally, as no automatism is active.
These manual steps are described in detail below.


## Run it

You just need to start the client component, as the proxy is either supposed
to be already running on a different machine or is started by the client
locally.


### Gpg4Win installations

You can start the GpgOL/Web client directly from the Windows start menu.

If you prefer to start it manually, e.g. to see verbose logs, run the following
using the paths of your installation:

```
C:\Program Files\Gpg4Win\bin\gpgol-client.exe
```

### Self-compiled and GNU/Linux installations

Run the following from the root directory of the source tree:

```sh
./build/bin/gpgol-client
```


## Generate and install TLS certificate

To secure the communication between the GpgOL/Web proxy component ans Outlook,
a self-signed TLS certificate is used. This certificate needs to be generated
and properly installed.

When the GpgOL/Web client is started for the first time, a welcome message
appears. You are asked whether you want the proxy component to run locally,
or under a different URL. If you choose a local proxy component, once you
hit `Continue` a self-signed TLS certificate will be autogenerated if missing.
On Windows it will also be installed so that you can use it immediately with
Chrome, Firefox, or Edge. After this the proxy component is automatically
started. You can use the test page button from the dialog window to open
a test page in your web browser, which will show you whether the certificate
installation was successful or not.

This happens *automatically* on Windows installations with Gpg4Win. That is,
users of GNU/Linux systems currently still have to follow the manual
certificate installtion described below, unfortunately.


## Installing the Outlook extension

The `Setup` button also opens a dialog to assist you with registering the
add-in with Outlook. It shows the local path to the `manifest.xml` file
which you should copy to the clipboard. The `Open Outlook Extension Manager`
button below will launch the
[`Add-Ins for Outlook` manager](https://outlook.office365.com/owa/?path=/options/manageapps).
Be patient, it may take a while to load.

Switch to `My add-ins` in the menu on the left side, and choose
`Add a custom add-in` in the `Custom Addins` section below. Select
`Add from file...` and provide the `manifest.xml` file you have copied to ypur
clipboard. Double check that the path is actually correct.


## Build it yourself

Although GpgOL/Web is primarily used on Windows, the development is mainly done
on GNU/Linux. Currently the only supported method for building the add-in on
Windows is to build the full [Gpg4Win](https://www.gpg4win.org) installer. The
following instructions are therefore intended for GNU/Linux systems.


### Dependencies

The add-in needs

* [Qt6](https://www.qt.io)
* [KDE Frameworks 6](https://kde.org)
* [libkleo](https://invent.kde.org/pim/libkleo)
* [mimetreeparser](https://invent.kde.org/pim/mimetreeparser)
* [QGpgME](https://git.gnupg.org/cgi-bin/gitweb.cgi?p=gpgmeqt.git;a=summary)

If your distribution provides a sufficient up to date version of these, the
easiest way is to install the development packages via your package manager.
Otherwise, you can build all the dependencies yourself with
[kdesrc-build](https://community.kde.org/Get_Involved/development).


### Compile

Then clone and build GpgOL/Web:

```sh
git clone https://dev.gnupg.org/source/gpgol.js.git
cd gpgol.js
cd web
nvm use 22
npm run build
cd ..
cmake -GNinja -DCMAKE_EXPORT_COMPILE_COMMANDS=1 -DCMAKE_BUILD_TYPE=Debug -S . build
cmake --build build && cmake --install build
```

*Note:* If you compiled the extension yourself, you will have to set the local
paths in the shell you want to start it from. You can do this by simply calling

```sh
source build/prefix.sh
```

from the sources root directory. After this, the components should run without
issues.


## Manual TLS certificate installation

This section only applies for users who can't use the automatic certificate
installation described above. For these cases, we recommend importing the
autogenerated Root CA certificate into the certificate store of the web
browser you want to use with Outlook.

### Import via browser GUI

Browsers like [Chrome](chrome://settings/certificates) or
[Firefox](about:preferences#privacy) have a configuration dialog for managing
certificates in their settings. You can use it to import the certificate
which by default is saved to `~/.local/share/gpgol-client/root-ca.pem`. If
asked, you should trust ths certificate to validate webpages.

### Import via command line

Alternatively, you can also import the certificate on the command line using
`certutil` from the [`Network Security Services (NSS)`](https://en.wikipedia.org/wiki/Network_Security_Services).
Check your distribution for packages providing it (e.g., `libnss3-tools` on
Debian-based distributions or `nss-tools` on Fedora).

To make `certutil` import the certificate correctly, you must point it to
the PKI directory your browser uses. It might accept certificates from
`$HOME/.pki/nssdb`, Snap based browsers might search somplace else (like
`$HOME/snap/chromium/current/.pki/nssdb` or
`$HOME/snap/firefox/common/.mozilla/firefox/<user id>.default`). Please
refer to your browser's documentation. Replace `$HOME/.pki/nssdb` in
the examples with the correct location:

```sh
# import the generated root CA certificate
certutil -d $HOME/.pki/nssdb -A -n "GpgOL/Web Root CA" -t "CT,c,c" -i $HOME/.local/share/gpgol-client/root-ca.pem
# list all certificates currently registered
certutil -d $HOME/.pki/nssdb -L
```

You can also remove the certificate from the database this way:

```sh
# remove the generated root CA certificate
certutil -d $HOME/.pki/nssdb -D -n "GpgOL/Web Root CA"
# list all certificates currently registered
certutil -d $HOME/.pki/nssdb -L
```


## Debugging

By default, logs are send to stderr. You can also store the logs to a directory
by setting `GPGOL_SERVER_LOGDIR` and `GPGOL_CLIENT_LOGDIR` environment variable.

This assumes the directory exists.

For example:

```sh
mkdir -p /tmp/gpgol/log
export GPGOL_CLIENT_LOGDIR=/tmp/gpgol/log
export GPGOL_SERVER_LOGDIR=/tmp/gpgol/log
```
